#include "..\inc\mySkybox.h"
#include "myDirect3D.h"

mySkybox::mySkybox(void)
{
	m_vFormat	= 0;
	m_vCount	= 0;
	m_vBuffer	= NULL;
	m_iCount	= 0;
	m_iBuffer	= NULL;
	ZeroMemory(&m_position,sizeof(D3DXVECTOR3));
	m_rotationY	= 0;
	D3DXMatrixIdentity(&m_transform);
	m_texture	= NULL;
	m_wid		= 50000; // width  (x)
	m_hgt		= 50000; // height (y)
	m_dep		= 50000; // depth  (z)
}

mySkybox::~mySkybox(void)
{
	clean();
}

bool mySkybox::init()
{
	// Setting up the Vertex Buffer
	myVertex verticies[] = {
		{     0,     0,     0,	 .5, .5}, // FRONT
		{ m_wid,     0,     0,	.25, .5},
		{ m_wid, m_hgt,     0,	.25,.25},
		{     0, m_hgt,     0,	 .5,.25},

 		{ m_wid,     0, m_dep,	  1, .5}, // BACK  
		{     0,     0, m_dep,	.75, .5},		   
		{     0, m_hgt, m_dep,	.75,.25},		   
		{ m_wid, m_hgt, m_dep,	  1,.25},		   

		{     0,     0, m_dep,	.75, .5}, //RIGHT
		{     0,     0,     0,	 .5, .5},
		{     0, m_hgt,     0,	 .5,.25},
		{     0, m_hgt, m_dep,	.75,.25},

		{ m_wid,     0,     0,	.25, .5}, // LEFT
		{ m_wid,     0, m_dep,	  0, .5},			
		{ m_wid, m_hgt, m_dep,	  0,.25},			
		{ m_wid, m_hgt,     0,	.25,.25},			

		{ m_wid, m_hgt, m_dep,	.25,  0}, // TOP
		{     0, m_hgt, m_dep,	 .5,  0},
		{     0, m_hgt,     0,	 .5,.25},
		{ m_wid, m_hgt,     0,	.25,.25}, 

		{     0,     0, m_dep,	 .5,.75}, // BOTTOM
		{ m_wid,     0, m_dep,  .25,.75},
		{ m_wid,     0,     0,	.25, .5},
		{     0,     0,     0,	 .5, .5}
	};
	m_vFormat = D3DFVF_XYZ | D3DFVF_TEX1;
	m_vCount = 24;
	
	HRESULT hr;
	hr = myDirect3D::getDevice()->CreateVertexBuffer(
		sizeof(myVertex)*m_vCount,
		0,
		m_vFormat,
		D3DPOOL_DEFAULT,
		&m_vBuffer,
		NULL);
	if(FAILED(hr)) return false;

	void* data;
	hr = m_vBuffer->Lock(0,0,&data,0);
	if(FAILED(hr)) return false;
		memcpy(data,verticies,sizeof(myVertex)*m_vCount);	
	m_vBuffer->Unlock();

	// Setting up the Index Buffer
	WORD indicies[] = {
		0,1,2, // front
		0,2,3,
		4,5,6, // back
		4,6,7,
		8,9,10, // right
		8,10,11,
		12,13,14, // left
		12,14,15,
		16,17,18, // top
		16,18,19,
		20,21,22, // bottom
		20,22,23
	};
	m_iCount = 36;

	hr = myDirect3D::getDevice()->CreateIndexBuffer(
		sizeof(WORD)*m_iCount,
		0,
		D3DFMT_INDEX16,
		D3DPOOL_DEFAULT,
		&m_iBuffer,
		NULL);
	if(FAILED(hr)) return false;

	data = NULL;
	hr = m_iBuffer->Lock(0,0,&data,0);
	if(FAILED(hr)) return false;
		memcpy(data,indicies,sizeof(WORD)*m_iCount);
	m_iBuffer->Unlock();

	hr = D3DXCreateTextureFromFileEx(
		myDirect3D::getDevice(),
		"../../data/skybox.bmp",
		D3DX_DEFAULT_NONPOW2,D3DX_DEFAULT_NONPOW2,
		1,
		0,
		D3DFMT_A8R8G8B8,
		D3DPOOL_DEFAULT,
		D3DX_DEFAULT,
		D3DX_DEFAULT,
		0xFF000000,
		NULL,
		NULL,
		&m_texture);
	if(FAILED(hr)) return false;

	myDirect3D::getD3D()->registerModel(this);
	return true;
}

void mySkybox::draw()
{
	D3DXMATRIX oldWorld;
	myDirect3D::getDevice()->GetTransform(D3DTS_WORLD,&oldWorld);
	myDirect3D::getDevice()->SetTransform(D3DTS_WORLD,&m_transform);
	myDirect3D::getDevice()->SetTexture(0,m_texture);

		myDirect3D::getDevice()->SetStreamSource(0,m_vBuffer,0,sizeof(myVertex));
		myDirect3D::getDevice()->SetIndices(m_iBuffer);
		myDirect3D::getDevice()->SetFVF(m_vFormat);
		myDirect3D::getDevice()->DrawIndexedPrimitive(
			D3DPT_TRIANGLELIST,0,0,m_vCount,0,12);

	myDirect3D::getDevice()->SetTexture(0,NULL);
	myDirect3D::getDevice()->SetTransform(D3DTS_WORLD,&oldWorld);
}

void mySkybox::clean()
{
	myDirect3D::getD3D()->unregisterModel(this);
	if(m_vBuffer == NULL)
	{
		m_vBuffer->Release();	
		m_vBuffer = NULL;
	}
	if(m_iBuffer == NULL)
	{
		m_iBuffer->Release();
		m_iBuffer = NULL;
	}
	m_vFormat	= 0;
	m_vCount	= 0;
	m_iCount	= 0;
	ZeroMemory(&m_position,sizeof(D3DXVECTOR3));
	m_rotationY	= 0;
	D3DXMatrixIdentity(&m_transform);
}

void mySkybox::setPosition(float x, float y, float z)
{
	D3DXMATRIX rotation, translation;
	m_position.x = x; m_position.y = y; m_position.z = z;
	D3DXMatrixRotationY(&rotation,m_rotationY);
	D3DXMatrixTranslation(&translation,m_position.x,m_position.y,m_position.z);

	D3DXMatrixMultiply(&m_transform,&rotation,&translation);
}

void mySkybox::setRotationY(float theta)
{
	D3DXMATRIX rotation, translation;
	m_rotationY = theta;
	D3DXMatrixRotationY(&rotation,m_rotationY);
	D3DXMatrixTranslation(&translation,m_position.x,m_position.y,m_position.z);

	D3DXMatrixMultiply(&m_transform,&rotation,&translation);
}