#include "..\inc\myXModel.h"
#include "myDirect3D.h"
#include "main.h"


myXModel::myXModel(void)
{
	m_mesh = NULL;
	m_materialCount = 0;
}

myXModel::~myXModel(void)
{
	clean();
}
bool myXModel::init()
{
	LPD3DXBUFFER materials;
	//D3DXCreateTeapot(myDirect3D::getDevice(), &m_mesh, NULL);
	HRESULT hr;
	hr =	D3DXLoadMeshFromX("../../data/stuff.x", // pg. 172
		D3DXMESH_SYSTEMMEM,
		myDirect3D::getDevice(),
		NULL,
		&materials,
		NULL,
		&m_materialCount,
		&m_mesh);
	if(FAILED(hr))return false;
	m_materials = new D3DMATERIAL9[m_materialCount];
	D3DXMATERIAL* mat = (D3DXMATERIAL*)materials->GetBufferPointer();

    for(DWORD i=0; i<m_materialCount; i++)
	{
		// Copy over texture filename.
		m_materials[i] = mat[i].MatD3D;
		m_materials[i].Ambient = m_materials[i].Diffuse;
	}
		
	myDirect3D::getD3D()->registerModel(this);

	return true;
}
void myXModel::draw()
{
	D3DXMATRIX t;
	D3DXMatrixScaling(&t,5,5,5);
	myDirect3D::getDevice()->SetTransform(D3DTS_WORLD,&t);

	for(int i=0; i<m_materialCount;i++)
	{
		myDirect3D::getDevice()->SetMaterial(&(m_materials[i]));
		m_mesh->DrawSubset(i);
	}
	
}
void myXModel::clean()
{
	if(m_mesh!=NULL)
	{
		m_mesh->Release();
		m_mesh=NULL;
	}
}