#include "..\inc\mywindow.h"
#include "myLevel.h"

myWindow::myWindow(void)
{
	m_hInstance = NULL;
	m_hwnd		= NULL;
}

myWindow::~myWindow(void)
{
	clean();
}

LRESULT CALLBACK WndProc(HWND wnd, UINT message, WPARAM wparam, LPARAM lparam);

bool myWindow::init(HINSTANCE hInstance, int show)
{
	m_hInstance = hInstance;

	// register window class
	WNDCLASSEX wc;
	ZeroMemory(&wc,sizeof(wc));
	wc.cbSize = sizeof(WNDCLASSEX);
	wc.style = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc = (WNDPROC)WndProc;
	wc.hInstance = hInstance;
	wc.hCursor = LoadCursor(NULL,IDC_ARROW);
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
	wc.lpszClassName = "myWindowClass";
	RegisterClassEx(&wc);

	m_hwnd = CreateWindow(
		"myWindowClass",
		"SHARP SHOOTER",
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, CW_USEDEFAULT,
		640, 480,
		NULL,NULL,
		hInstance,
		NULL);
	if(!m_hwnd) return false;

	ShowWindow(m_hwnd,show);
	UpdateWindow(m_hwnd);
	return true;
}

void myWindow::clean()
{
	UnregisterClass("myWindowClass",m_hInstance);
	m_hInstance = NULL;
	m_hwnd		= NULL;
}

void myWindow::handleWindowsMessage(HWND wnd, UINT message, WPARAM wparam, LPARAM lparam)
{
	switch(message)
	{
	case WM_KEYDOWN:
		if(wparam == VK_UP)
			myLevel::getCurrent()->handleMessage(myLevel::MYMT_MOVEUP,NULL);
		if(wparam == VK_DOWN)
			myLevel::getCurrent()->handleMessage(myLevel::MYMT_MOVEDOWN,NULL);
		if(wparam == 27)
			PostQuitMessage(0);
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	}
}

HWND myWindow::getHWND()
{
	return m_hwnd;
}
