#include "..\inc\mytriangle.h"
#include "myDirect3D.h"

myTriangle::myTriangle(void)
{
	m_vFormat	= 0;
	m_vCount	= 0;
	m_vBuffer	= NULL;
}

myTriangle::~myTriangle(void)
{
	clean();
}

bool myTriangle::init()
{
	myVertex verticies[] = {
		{320,50,0.5,1,		0xffff0000},
		{250,400,0.5,1,		0xff00ff00},
		{50,400,0.5,1,		0xff0000ff}
	};
	m_vFormat = D3DFVF_XYZRHW | D3DFVF_DIFFUSE;
	m_vCount = 3;
	
	HRESULT hr;
	hr = myDirect3D::getDevice()->CreateVertexBuffer(
		sizeof(myVertex)*m_vCount,
		0,
		m_vFormat,
		D3DPOOL_DEFAULT,
		&m_vBuffer,
		NULL);
	if(FAILED(hr)) return false;

	void* data;
	hr = m_vBuffer->Lock(0,0,&data,0);
	if(FAILED(hr)) return false;
		memcpy(data,verticies,sizeof(myVertex)*m_vCount);	
	m_vBuffer->Unlock();

	myDirect3D::getD3D()->registerModel(this);

    return true;
}

void myTriangle::draw()
{
	myDirect3D::getDevice()->SetStreamSource(0,m_vBuffer,0,sizeof(myVertex));
	myDirect3D::getDevice()->SetFVF(m_vFormat);
	myDirect3D::getDevice()->DrawPrimitive(D3DPT_TRIANGLELIST,0,1);
}

void myTriangle::clean()
{
	myDirect3D::getD3D()->unregisterModel(this);

	if(m_vBuffer != NULL)
	{
		m_vBuffer->Release();
		m_vBuffer = NULL;
	}
	m_vFormat	= 0;
	m_vCount	= 0;
}