#include "..\inc\mysquare.h"
#include "myDirect3D.h"

mySquare::mySquare(void)
{
	m_vFormat	= 0;
	m_vCount	= 0;
	m_vBuffer	= NULL;
}

mySquare::~mySquare(void)
{
	clean();
}

bool mySquare::init()
{
	myVertex verticiesList[] = { // TRIANGLELIST
		{250,50,0.5,1,		0xffff0000}, // top right
		{250,250,0.5,1,		0xff00ff00}, // bottom right
		{50,250,0.5,1,		0xff0000ff}, // bottom left
		{250,50,0.5,1,		0xffff0000}, // top right
		{50,250,0.5,1,		0xff0000ff}, // bottom left
		{50,50,0.5,1,		0xff00ff00}  // top left
	};
	myVertex verticiesStrip[] = { // TRIANGLESTRIP
		{250,50,0.5,1,		0xffff0000}, // top right
		{250,250,0.5,1,		0xff00ff00}, // bottom right
		{50,50,0.5,1,		0xff00ff00}, // top left
		{50,250,0.5,1,		0xff0000ff}, // bottom left
	};
	myVertex verticiesFan[] = { // TRIANGLEFAN
		{250,50,0.5,1,		0xffff0000}, // top right
		{250,250,0.5,1,		0xff00ff00}, // bottom right
		{50,250,0.5,1,		0xff0000ff}, // bottom left
		{50,50,0.5,1,		0xff00ff00}  // top left
	};
	m_vFormat = D3DFVF_XYZRHW | D3DFVF_DIFFUSE;
	m_vCount = 6;
	
	HRESULT hr;
	hr = myDirect3D::getDevice()->CreateVertexBuffer(
		sizeof(myVertex)*m_vCount,
		0,
		m_vFormat,
		D3DPOOL_DEFAULT,
		&m_vBuffer,
		NULL);
	if(FAILED(hr)) return false;

	void* data;
	hr = m_vBuffer->Lock(0,0,&data,0);
	if(FAILED(hr)) return false;
		memcpy(data,verticiesList,sizeof(myVertex)*m_vCount);	
	m_vBuffer->Unlock();

	myDirect3D::getD3D()->registerModel(this);

    return true;
}

void mySquare::draw()
{
	myDirect3D::getDevice()->SetStreamSource(0,m_vBuffer,0,sizeof(myVertex));
	myDirect3D::getDevice()->SetFVF(m_vFormat);
	myDirect3D::getDevice()->DrawPrimitive(D3DPT_TRIANGLELIST,0,2);
}

void mySquare::clean()
{
	myDirect3D::getD3D()->unregisterModel(this);

	if(m_vBuffer != NULL)
	{
		m_vBuffer->Release();
		m_vBuffer = NULL;
	}
	m_vFormat	= 0;
	m_vCount	= 0;
}