#include ".\mysprite.h"
#include "myDirect3D.h"

mySprite::mySprite(void)
{
	myImage();
	m_texture = NULL;
}

mySprite::~mySprite(void)
{
	clean();
}

bool mySprite::load(char* filename, bool isVisible)
{
	D3DXIMAGE_INFO ii;
	HRESULT hr;
	hr = D3DXCreateTextureFromFileEx(
		myDirect3D::getDevice(),
		filename,
		D3DX_DEFAULT_NONPOW2,D3DX_DEFAULT_NONPOW2,
		1,
		0,
		D3DFMT_A8R8G8B8,
		D3DPOOL_DEFAULT,
		D3DX_DEFAULT,
		D3DX_DEFAULT,
		0xFF000000,
		&ii,
		NULL,
		&m_texture);
	if(FAILED(hr)) return false;

	hr = m_texture->GetSurfaceLevel(0,&m_surface);
	if(FAILED(hr)) return false;

	m_width = ii.Width;
	m_height = ii.Height;
	setVisible(isVisible);
	myDirect3D::getD3D()->registerImage(this);

	return true;
}

void mySprite::draw()
{
	if(!m_isVisible) return;
	if(m_next != NULL)
	{
		DWORD current = GetTickCount();
		if(((int)(current-m_startTime)) > m_msDisplay)
		{
			m_isVisible = false;
			m_next->setVisible(true);
		}
	}
	RECT r;
	r.left		= m_x;
	r.top		= m_y;
	r.right		= m_x + (int)(m_scale*m_width);
	r.bottom	= m_y + (int)(m_scale*m_height);

	D3DXVECTOR3 v;
	v.x = (float)m_x; v.y = (float)m_y; v.z = 0;
	myDirect3D::getSprite()->Draw(m_texture,NULL,NULL,&v,0xFFFFFFFF);
}

void mySprite::clean()
{
	myImage::clean();
	if(m_texture != NULL)
	{
		m_texture->Release();
		m_texture = NULL;
	}
}
