#include "..\inc\myMovableCube.h"
#include "myDirect3D.h"

myMovableCube::myMovableCube(void)
{
	m_vFormat	= 0;
	m_vCount	= 0;
	m_vBuffer	= NULL;
	m_iCount	= 0;
	m_iBuffer	= NULL;
	ZeroMemory(&m_position,sizeof(D3DXVECTOR3));
	m_rotationY	= 0;
	D3DXMatrixIdentity(&m_transform);
}

myMovableCube::~myMovableCube(void)
{
	clean();
}

bool myMovableCube::init()
{
	// Setting up the Vertex Buffer
	myVertex verticies[] = {
		{-100,-100,-100,	0xff000000},
		{ 100,-100,-100,	0xffff0000},
		{ 100, 100,-100,	0xffffff00},
		{-100, 100,-100,	0xff00ff00},
		{-100,-100, 100,	0xff0000ff},
		{ 100,-100, 100,	0xffff00ff},
		{ 100, 100, 100,	0xffffffff},
		{-100, 100, 100,	0xff00ffff}
	};
	m_vFormat = D3DFVF_XYZ | D3DFVF_DIFFUSE;
	m_vCount = 8;
	
	HRESULT hr;
	hr = myDirect3D::getDevice()->CreateVertexBuffer(
		sizeof(myVertex)*m_vCount,
		0,
		m_vFormat,
		D3DPOOL_DEFAULT,
		&m_vBuffer,
		NULL);
	if(FAILED(hr)) return false;

	void* data;
	hr = m_vBuffer->Lock(0,0,&data,0);
	if(FAILED(hr)) return false;
		memcpy(data,verticies,sizeof(myVertex)*m_vCount);	
	m_vBuffer->Unlock();

	// Setting up the Index Buffer
	WORD indicies[] = {
		0,2,1, // back
		0,3,2,
		4,5,6, // front
		4,6,7,
		4,3,0, // left
		4,7,3,
		5,2,6, // right
		5,1,2,
		7,2,3, // top
		7,6,2,
		4,1,5, // bottom
		4,0,1
	};
	m_iCount = 36;

	hr = myDirect3D::getDevice()->CreateIndexBuffer(
		sizeof(WORD)*m_iCount,
		0,
		D3DFMT_INDEX16,
		D3DPOOL_DEFAULT,
		&m_iBuffer,
		NULL);
	if(FAILED(hr)) return false;

	data = NULL;
	hr = m_iBuffer->Lock(0,0,&data,0);
	if(FAILED(hr)) return false;
		memcpy(data,indicies,sizeof(WORD)*m_iCount);
	m_iBuffer->Unlock();

	myDirect3D::getD3D()->registerModel(this);
	return true;
}

void myMovableCube::draw()
{
	D3DXMATRIX oldWorld;
	myDirect3D::getDevice()->GetTransform(D3DTS_WORLD,&oldWorld);
	myDirect3D::getDevice()->SetTransform(D3DTS_WORLD,&m_transform);

		myDirect3D::getDevice()->SetStreamSource(0,m_vBuffer,0,sizeof(myVertex));
		myDirect3D::getDevice()->SetIndices(m_iBuffer);
		myDirect3D::getDevice()->SetFVF(m_vFormat);
		myDirect3D::getDevice()->DrawIndexedPrimitive(
			D3DPT_TRIANGLELIST,0,0,m_vCount,0,12);

	myDirect3D::getDevice()->SetTransform(D3DTS_WORLD,&oldWorld);
}

void myMovableCube::clean()
{
	myDirect3D::getD3D()->unregisterModel(this);
	if(m_vBuffer == NULL)
	{
		m_vBuffer->Release();	
		m_vBuffer = NULL;
	}
	if(m_iBuffer == NULL)
	{
		m_iBuffer->Release();
		m_iBuffer = NULL;
	}
	m_vFormat	= 0;
	m_vCount	= 0;
	m_iCount	= 0;
	ZeroMemory(&m_position,sizeof(D3DXVECTOR3));
	m_rotationY	= 0;
	D3DXMatrixIdentity(&m_transform);
}

void myMovableCube::setPosition(float x, float y, float z)
{
	D3DXMATRIX rotation, translation;
	m_position.x = x; m_position.y = y; m_position.z = z;
	D3DXMatrixRotationY(&rotation,m_rotationY);
	D3DXMatrixTranslation(&translation,m_position.x,m_position.y,m_position.z);

	D3DXMatrixMultiply(&m_transform,&rotation,&translation);
}

void myMovableCube::setRotationY(float theta)
{
	D3DXMATRIX rotation, translation;
	m_rotationY = theta;
	D3DXMatrixRotationY(&rotation,m_rotationY);
	D3DXMatrixTranslation(&translation,m_position.x,m_position.y,m_position.z);

	D3DXMatrixMultiply(&m_transform,&rotation,&translation);
}