#include "..\inc\mylight.h"
#include "myDirect3D.h"

int myLight::m_nextLightIndex = 0;

myLight::myLight(void)
{
	ZeroMemory(&m_light,sizeof(D3DLIGHT9));
	m_index = -1;
}

myLight::~myLight(void)
{
	clean();
}

bool myLight::init()
{
	m_index = m_nextLightIndex;
	m_nextLightIndex++;

	m_light.Type = D3DLIGHT_POINT;
	m_light.Diffuse.r = 0.75;
	m_light.Diffuse.g = 0.75;
	m_light.Diffuse.b = 0.0;
	m_light.Specular.r = 1.0;
	m_light.Specular.g = 1.0;
	m_light.Specular.b = 1.0;
	m_light.Position.x = 2000;
	m_light.Position.y = 200;
//	m_light.Direction.y = -1;
//	m_light.Attenuation0 = 1.0;
	m_light.Range = sqrt(FLT_MAX);

	HRESULT hr;
	hr = myDirect3D::getDevice()->SetLight(m_index,&m_light);
	if(FAILED(hr)) return false;
	hr = myDirect3D::getDevice()->LightEnable(m_index,TRUE);
	if(FAILED(hr)) return false;

	return true;
}

void myLight::clean()
{
	if(m_index != -1)
	{
		myDirect3D::getDevice()->LightEnable(m_index,FALSE);
		ZeroMemory(&m_light,sizeof(D3DLIGHT9));
		m_index = -1;
	}
}