#include "..\inc\mylevel.h"
#include "myDirect3D.h"
#include "myImage.h"
#include "mySprite.h"
#include "myTriangle.h"
#include "mySquare.h"
#include "myStar.h"
#include "myCube.h"
#include "myMovableCube.h"
#include "myLitCube.h"
#include "myLight.h"
#include "myTexturedCube.h"
#include "myTeapot.h"
#include "myXModel.h"
#include"mySkybox.h"
myLevel* myLevel::m_current = NULL;

myLevel::myLevel(void)
{
	m_testImage = NULL;
	m_model		= NULL;
	m_tix		= 100;
	m_tiy		= 100;
	m_light		= NULL;
}

myLevel::~myLevel(void)
{
	clean();
}

bool myLevel::load()
{
	if(m_current == NULL)
		m_current = this;

	m_testImage = new mySprite();
	if(!m_testImage->load("../../data/somethingFun.bmp",false))
		return false;
	m_testImage->setPosition(100,100);

	m_model = new mySkybox();
	if(!m_model->init())
		return false;

	m_light = new myLight();
	if(!m_light->init())
		return false;

	return true;
}

void myLevel::update()
{
//	m_tix += 5;
//	if(m_tix>400)
//		m_tix -= 400;
//	m_testImage->setPosition(m_tix,m_tiy);
//	((myMovableCube*)m_model)->setPosition((float)m_tix,0,0);
//	((myMovableCube*)m_model)->setRotationY(m_tix/100.0f);
}

void myLevel::clean()
{
	if(m_light != NULL)
	{
		m_light->clean();
		delete m_light;
		m_light = NULL;
	}
	if(m_model != NULL)
	{
		m_model->clean();
		delete m_model;
		m_model = NULL;
	}
	if(m_testImage != NULL)
	{
		m_testImage->clean();
		delete m_testImage;
		m_testImage = NULL;
	}
}

void myLevel::handleMessage(myMessageType type, void* data)
{
	switch(type)
	{
	case MYMT_MOVEDOWN:
		m_tiy = 300;
		break;
	case MYMT_MOVEUP:
		m_tiy = 100;
		break;
	case MYMT_MOVELEFTRIGHT:
		m_tix += (int)*(LONG*)data;
		break;
	case MYMT_ROTATELEFTRIGHT:
		// Need to rotate the camera's target around the camera position.
		myDirect3D::getD3D()->rotateCameraXZ(data);
		break;
	case MYMT_TILTUPDOWN:
		// Need to adjust the camera's target up and down.
		myDirect3D::getD3D()->tiltCameraY(data);
		break;
	}
}

myLevel* myLevel::getCurrent()
{
	return m_current;
}

void myLevel::setCurrent(myLevel* newLevel)
{
	m_current = newLevel;
}
