#include "..\inc\mygame.h"
#include "myWindow.h"
#include "myDirect3D.h"
#include "myLevel.h"
#include "myMouse.h"

myGame::myGame(void)
{
	m_hInstance	= NULL;
	m_isOver	= false;
	m_window	= NULL;
	m_direct3D	= NULL;
	m_level		= NULL;
	m_mouse		= NULL;
}

myGame::~myGame(void)
{
	clean();
}

void myGame::init(HINSTANCE hInstance, int show)
{
	m_hInstance = hInstance;
	m_window = new myWindow();
	if(!m_window->init(hInstance,show))
	{
		m_isOver = true;
		return;
	}

	m_direct3D = myDirect3D::getD3D();
	if(!m_direct3D->init(m_window->getHWND()))
	{
		m_isOver = true;
		return;
	}

	m_mouse = new myMouse();
	if(!m_mouse->init(hInstance,m_window->getHWND()))
	{
		m_isOver = true;
		return;
	}

	m_level = new myLevel();
	if(!m_level->load())
	{
		m_isOver = true;
		return;
	}
}

bool myGame::isOver()
{
	return m_isOver;
}

void myGame::update()
{
	MSG msg;
	ZeroMemory(&msg,sizeof(msg));
	if(PeekMessage(&msg,NULL,0,0,PM_REMOVE))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	else
	{
		m_mouse->poll();
		myLevel::getCurrent()->update();
		m_direct3D->render();
	}

	if(msg.message == WM_QUIT) m_isOver = true;
}

void myGame::clean()
{
	if(m_level != NULL)
	{
		m_level->clean();
		delete m_level;
		m_level = NULL;
	}

	if(m_mouse != NULL)
	{
		m_mouse->clean();
		delete m_mouse;
		m_mouse = NULL;
	}

	if(m_direct3D != NULL)
	{
		m_direct3D->clean();
		delete m_direct3D;
		m_direct3D = NULL;
	}

	if(m_window != NULL)
	{
		m_window->clean();
		delete m_window;
		m_window = NULL;
	}
}

void myGame::handleWindowsMessage(HWND wnd, UINT message, WPARAM wparam, LPARAM lparam)
{
	m_window->handleWindowsMessage(wnd,message,wparam,lparam);
}
