#include "..\inc\mycamera.h"
#include "myDirect3D.h"

myCamera::myCamera(void)
{
	ZeroMemory(m_position,sizeof(D3DXVECTOR3));
	ZeroMemory(m_target,sizeof(D3DXVECTOR3));
	ZeroMemory(m_up,sizeof(D3DXVECTOR3));

	ZeroMemory(m_world,sizeof(D3DXMATRIX));
	ZeroMemory(m_view,sizeof(D3DXMATRIX));
	ZeroMemory(m_projection,sizeof(D3DXMATRIX));

	theta = 0.0; // Rotation from +Z. positive=counterclockwise negative=clockwise
}

myCamera::~myCamera(void)
{
	clean();
}

bool myCamera::init()
{
	m_position.x = 25000; m_position.y = 25000; m_position.z = 25000;
	m_target.x = 25000; m_target.y = 25000; m_target.z = 26000;
	m_up.y = 1;

	D3DXMatrixIdentity(&m_world);
	D3DXMatrixLookAtLH(&m_view,&m_position,&m_target,&m_up);
	D3DXMatrixPerspectiveFovLH(&m_projection,D3DX_PI/4,640.0f/480,1.0f,100000.0f);
	
	return true;
}
void myCamera::useCamera()
{
	myDirect3D::getDevice()->SetTransform(D3DTS_WORLD,&m_world);
	myDirect3D::getDevice()->SetTransform(D3DTS_VIEW,&m_view);
	myDirect3D::getDevice()->SetTransform(D3DTS_PROJECTION,&m_projection);

	myDirect3D::getDevice()->SetRenderState(D3DRS_ZENABLE,D3DZB_TRUE);

	myDirect3D::getDevice()->SetRenderState(D3DRS_LIGHTING,false);
//	myDirect3D::getDevice()->SetRenderState(D3DRS_NORMALIZENORMALS,TRUE);
//	myDirect3D::getDevice()->SetRenderState(D3DRS_SPECULARENABLE,TRUE);
//	myDirect3D::getDevice()->SetRenderState(D3DRS_AMBIENT,0x33333333);

//	myDirect3D::getDevice()->SetRenderState(
}
void myCamera::clean()
{
	ZeroMemory(m_position,sizeof(D3DXVECTOR3));
	ZeroMemory(m_target,sizeof(D3DXVECTOR3));
	ZeroMemory(m_up,sizeof(D3DXVECTOR3));

	ZeroMemory(m_world,sizeof(D3DXMATRIX));
	ZeroMemory(m_view,sizeof(D3DXMATRIX));
	ZeroMemory(m_projection,sizeof(D3DXMATRIX));
}
void myCamera::rotateCameraXZ(void* data)
{
	//if(*(long*)data != 0) // testing variable data.
	//	SHOWINT((int)*(long*)data); // testing variable data.
	theta = (float)*(long*)data; // rotation change (+ or -)
	theta /= 20; // Reduce the amount of change.

	D3DXVECTOR3 m_temp; // Base vector to hold temp data
	m_temp = m_target - m_position; // Copy current Forward vector into m_temp

	// Convert theta to radians.
	float thetaRAD = theta * (D3DX_PI/180);

	// Rotate temp vector about y axis.
	float newX, newZ;
	newX = m_temp.x*cos(thetaRAD) + m_temp.z*sin(thetaRAD);
	newZ = m_temp.z*cos(thetaRAD) - m_temp.x*sin(thetaRAD);

	// Add current camera position X and Z to temp
	m_temp.x = newX + m_position.x;
	m_temp.z = newZ + m_position.z;

	// Modify m_target X an Z positions
	m_target.x = m_temp.x;
	m_target.z = m_temp.z;

	// Normalize temp vector.
	//float k = 1;
	//float denom = sqrt(m_temp.x*m_temp.x + m_temp.y*m_temp.y + m_temp.z*m_temp.z);
	//if (denom!=0)
	//{
	//	float k = 1 / denom;
	//}

	//m_temp *= k; // Normalizing the vector.	

	// Project temp out to base distance of 1000.
	//m_temp *= 1000.0;

	//m_target.x=m_temp.x; // Adjust m_target.x to new location, inherit current y position
	//m_target.z=m_temp.z; // Adjust m_target.z to new location, inherit current y position

	//m_target.x += 2*(int)*(long*)data; // Initial testing version.
	D3DXMatrixLookAtLH(&m_view,&m_position,&m_target,&m_up); // Look at new position.
}
void myCamera::rotateCameraY(void* data)
{
	//if(*(long*)data != 0)
	//	SHOWINT((int)*(long*)data);
	m_target.y += -2*(int)*(long*)data;
	D3DXMatrixLookAtLH(&m_view,&m_position,&m_target,&m_up);
}