#pragma once
#include "main.h"
#include "mymodel.h"

class myTexturedCube : public myModel
{
public:
	myTexturedCube(void);
	~myTexturedCube(void);

	virtual bool init();
	virtual void draw();
	virtual void clean();

	void setPosition(float x, float y, float z);
	void setRotationY(float theta);

private:
	typedef struct s_myVertex {
		float x,y,z;
		float u,v;
	} myVertex;

	DWORD					m_vFormat;
	int						m_vCount;
	LPDIRECT3DVERTEXBUFFER9	m_vBuffer;
	int						m_iCount;
	LPDIRECT3DINDEXBUFFER9	m_iBuffer;

	D3DXVECTOR3				m_position;
	float					m_rotationY;
	D3DXMATRIX				m_transform;

	LPDIRECT3DTEXTURE9		m_texture;
};