#pragma once
#include "main.h"
#include "mymodel.h"

class myTLCube : public myModel
{
public:
	myTLCube(void);
	~myTLCube(void);

	virtual bool init();
	virtual void draw();
	virtual void clean();

	void setPosition(float x, float y, float z);
	void setRotationY(float theta);

private:
	typedef struct s_myVertex {
		float x,y,z;
		float nx,ny,nz;
		float u,v;
	} myVertex;

	DWORD					m_vFormat;
	int						m_vCount;
	LPDIRECT3DVERTEXBUFFER9	m_vBuffer;
	int						m_iCount;
	LPDIRECT3DINDEXBUFFER9	m_iBuffer;

	D3DXVECTOR3				m_position;
	float					m_rotationY;
	D3DXMATRIX				m_transform;

	D3DMATERIAL9			m_material;

	LPDIRECT3DTEXTURE9		m_texture;
};




