#pragma once
#include "main.h"
class myImage;
class myModel;
class myCamera;

class myDirect3D
{
public:	
	static myDirect3D*			getD3D();
	static LPDIRECT3DDEVICE9	getDevice();
	static LPD3DXSPRITE			getSprite();

	~myDirect3D(void);

	bool init(HWND hwnd);
	void render();
	void clean();

	void setCurrentCamera(myCamera* camera);
	myCamera* getCurrentCamera();

	void registerImage(myImage* newImage);
	void unregisterImage(myImage* oldImage);
	void registerModel(myModel* newModel);
	void unregisterModel(myModel* oldModel);

	void myDirect3D::rotateCameraXZ(void* data);
	void myDirect3D::tiltCameraY(void* move);

private:
	myDirect3D(void);

	LPDIRECT3D9				m_d3d;
	LPDIRECT3DDEVICE9		m_d3dDevice;
	LPD3DXSPRITE			m_sprite;

	myCamera*				m_camera;

	typedef list<myImage*>	myImageList;
	myImageList*			m_images;
	typedef list<myModel*>	myModelList;
	myModelList*			m_models;

	static myDirect3D*		m_singleton;
};

